#include <iostream>

#include "eval.h"
#include "defs.h"
#include "pawntab.h"
#include "squares.h"
#include "bits.h"

void cEval::score_pawn(cBoard &brd, cMaterial &mat, cPawntable &pawntab)
{

	if(pawntab.probe_pawn(pawns[cW], pawns[cB], brd.getpawnkey()))
	{
	    return;
	}

	uint sq64=0,sq128=0,rank=0;
	bool back = false;
	bool iso = false;
	bool passed = false;
	bool doubled = false;
	bool open = false;
	bool can = false;

	u64 wocc,bocc,occ,allocc;

    wocc = mat.getboard(pwP);
    bocc = mat.getboard(pbP);
    allocc = wocc | bocc;
    occ = wocc;
	while(occ)
	{
		sq64 = POP(occ);
		sq128 = sqfrom64(sq64);
		ASS(sq64>=0&&sq64<64);
		ASS(onbrd(sq128));

		back = false;
		iso = false;
		passed = false;
		doubled = false;
		open = false;
		can = false;

		if(isfilenorth[sq64] & wocc) doubled = true;

		if(!(isfilenorth[sq64] & allocc))
		{
			open=true;
		}

		if(!(isisolated[sq64] & wocc))
		{
			iso=true;
		}

		if(!(whitepassed[sq64] & bocc))
		{
		    passed = true;
		}

#ifdef SPEAK
		cout<<"\n wP "<<printsquare(sq128);
		if(open) cout<<" open ";
		if(doubled) cout<<" doubled ";
		if(iso) cout<<" iso ";
		if(passed) cout<<" passed ";
		if(can)cout<<" can ";
#endif

	    rank = ranks[sq128];
	    ASS(rank>=RANK1&&rank<=RANK8);
		if(doubled)
		{
			pawns[cW][OPE] -= doubledopen;
			pawns[cW][END] -= doubledend;
		}

		if(iso)
		{
			if(open)
			{
				pawns[cW][OPE] -= isolatedopen+openfileopen;
				pawns[cW][END] -= isolatedend+openfileend;
			}
			else
			{
				pawns[cW][OPE] -= isolatedopen;
				pawns[cW][END] -= isolatedend;
			}
		}

		if(passed)
		{
			pawns[cW][OPE] += passeropen*rank;
			pawns[cW][END] += passerend*rank;
		}
/*
		if(can)
		{
			pawns[cW][OPE] += passeropen*rank;
			pawns[cW][END] += passerend*rank;
		}
*/
	   }

    occ = bocc;
	while(occ)
	{
		sq64 = POP(occ);
		sq128 = sqfrom64(sq64);
		ASS(sq64>=0&&sq64<64);
		ASS(onbrd(sq128));

		iso = false;
		passed = false;
		doubled = false;
		open = false;
		can = false;

		if(isfilesouth[sq64] & bocc) doubled = true;

		if(!(isfilesouth[sq64] & allocc))
		{
			open=true;
		}

		if(!(isisolated[sq64] & bocc))
		{
			iso=true;
		}

		if(!(blackpassed[sq64] & wocc))
		{
		    passed = true;
		}

#ifdef SPEAK
		cout<<"\n bP "<<printsquare(sq128);
		//cout<<" rank "<<rank<<" bb[file+1] "<<bb[file+1]<<" bb[file-1] "<<bb[file-1];
		if(open) cout<<" open ";
		if(doubled) cout<<" doubled ";
		if(iso) cout<<" iso ";
		if(passed) cout<<" passed ";
		if(can)cout<<" can ";
#endif
		rank = ranks[sq128];
		if(doubled)
		{
			pawns[cB][OPE] -= doubledopen;
			pawns[cB][END] -= doubledend;
		}

		if(iso)
		{
			if(open)
			{
				pawns[cB][OPE] -= isolatedopen+openfileopen;
				pawns[cB][END] -= isolatedend+openfileend;
			}
			else
			{
				pawns[cB][OPE] -= isolatedopen;
				pawns[cB][END] -= isolatedend;
			}
		}


		if(passed)
		{
			pawns[cB][OPE] += passeropen*rankrev[rank];
			pawns[cB][END] += passerend*rankrev[rank];
		}
/*
		if(can)
		{
			pawns[cB][OPE] += passeropen*rankrev[rank];
			pawns[cB][END] += passerend*rankrev[rank];
		}
		*/
		}

	pawntab.store_pawn(pawns[cW], pawns[cB], brd.getpawnkey());
}
